import { createAsyncThunk } from '@reduxjs/toolkit';
import { firstValueFrom, forkJoin, Observable } from 'rxjs';

import { SecretVersion } from '../../models';
import { getSecretsApi } from '../../services';

import { namespace } from '../state';

export interface LoadSecretVersionsOutput {
   [secretUuid: string]: SecretVersion[];
}

export const loadSecretVersions = createAsyncThunk<LoadSecretVersionsOutput, string[]>(
   `${namespace}/loadSecretVersions`,
   secretUuids => {
      const versionLoadRequests = secretUuids.reduce((acc, secretUuid) => {
         acc[secretUuid] = getSecretsApi().getVersions(secretUuid);

         return acc;
      }, {} as Record<string, Observable<SecretVersion[]>>);

      return firstValueFrom(forkJoin(versionLoadRequests));
   },
);
