import { createAsyncThunk } from '@reduxjs/toolkit';
import { firstValueFrom, forkJoin } from 'rxjs';

import { Secret, SecretVersion } from '../../models';
import { getSecretsApi } from '../../services';

import { namespace } from '../state';

export interface LoadSecretsOutput {
   secret: Secret;
   versions: SecretVersion[];
}

/**
 * Загружает всё, что известно о секретах (по списку их UUID)
 */
export const loadSecrets = createAsyncThunk<LoadSecretsOutput[], string[]>(`${namespace}/loadSecrets`, secretUuids => {
   const requests = secretUuids.map(secretUuid =>
      forkJoin({
         secret: getSecretsApi().getById(secretUuid),
         versions: getSecretsApi().getVersions(secretUuid),
      }),
   );

   return firstValueFrom(forkJoin(requests));
});
