import { createAsyncThunk } from '@reduxjs/toolkit';

import { selectDelegationToken } from '../selectors';
import { namespace, RootStateWithSecrets } from '../state';

export interface UpsertDeployUnitSecretVersionParams {
   alias: string;
   duId: string;
   newStorage: boolean;
   secretUuid: string;
   stageId: string;
   token?: string;
   versionUuid: string;
}

/**
 * Универсальный экшен для вставки или обновления версии секрета в DU
 *
 * Пытается подобрать подходящий токен
 */
export const upsertDeployUnitSecretVersion = createAsyncThunk<
   UpsertDeployUnitSecretVersionParams,
   UpsertDeployUnitSecretVersionParams
>(`${namespace}/upsertDeployUnitSecretVersion`, (params, thunkApi) => {
   // Новое хранилище не использует токены
   if (params.newStorage) {
      return params;
   }

   // Токен уже есть, выписывать дополнительно не надо
   if (params.token) {
      return params;
   }

   // Возможно токен есть у соседей (ведь он не зависит от версии, можно переиспользовать)
   const existToken = selectDelegationToken(
      thunkApi.getState() as RootStateWithSecrets,
      params.stageId,
      params.duId,
      params.secretUuid,
   );
   if (existToken) {
      return { ...params, token: existToken };
   }

   // Токена нет, ну и ладно (будет выписан перед показом diff)
   return params;
});
