import { createEntityAdapter } from '@reduxjs/toolkit';

import { DeployUnitSecret, Secret, SecretVersion } from '../models';

export const namespace = `secrets` as const;

type DeployUnitStore<T> = {
   [stageId: string]: {
      [deployUnitId: string]: T[];
   };
};

export const secretAdapter = createEntityAdapter<Secret>({
   selectId: secret => secret.uuid,
});

export const versionAdapter = createEntityAdapter<SecretVersion>({
   selectId: version => version.version,
});

interface VersionsOfSecrets {
   [secretUuid: string]: string[]; // value - массив versionUuid
}

export const initialState = {
   deployUnitSecrets: {} as DeployUnitStore<DeployUnitSecret>,
   secrets: secretAdapter.getInitialState(),
   versions: versionAdapter.getInitialState(),
   versionsOfSecret: {} as VersionsOfSecrets,
};

export type SecretStore = typeof initialState;

export interface RootStateWithSecrets {
   [namespace]: SecretStore;
}
