import React, { useEffect, useMemo } from 'react';
import { useDispatch } from 'react-redux';

import { StageConverter } from '../../../models/ui';
import { testSecretsStage } from '../../../stories/testData';

import { useDuSecrets } from '../hooks';
import { SecretsContext } from '../models';
import { loadSecrets, secretsSlice } from '../slice';

const stage = StageConverter.fromApi(testSecretsStage as any);

interface Props {
   duId?: string;
   loadDetails?: boolean;
}

export const StageWithSecretsStory: React.FC<Props> = ({
   duId = 'du_manual_secrets',
   loadDetails = false,
   children,
}) => {
   const dispatch = useDispatch();
   const duSecrets = useDuSecrets(SECRETS_DEMO_STAGE_ID, duId);

   useEffect(() => {
      dispatch(
         secretsSlice.actions.loadFromStage({
            stage,
            rawStageSpec: testSecretsStage.spec as any,
            recreate: true,
         }),
      );
   }, [dispatch]);

   useEffect(() => {
      // Загрузка данных о секретах (обогащение)
      const secretUuids = duSecrets?.map(s => s.secretUuid) ?? [];
      if (loadDetails && secretUuids.length > 0) {
         dispatch(loadSecrets(secretUuids));
      }
   }, [dispatch, duSecrets, loadDetails]);

   const context = useMemo(
      () => ({
         stageId: stage.id,
         duId,
         reloadUsages: () => console.log('RELOAD USAGE FIRED'),
      }),
      [duId],
   );

   return <SecretsContext.Provider value={context}>{children}</SecretsContext.Provider>;
};

export const SECRETS_DEMO_STAGE_ID = stage.id;
