import block from 'bem-cn-lite';

import { Menu, Popup } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './ActionPopup.scss';

const b = block('action-popup');

export default class ActionPopup extends React.Component {
   handleActionClick = (action, event) => {
      const { onActionClick } = this.props;

      if (onActionClick && !action.disabled) {
         onActionClick(action.id, event);
      }
   };

   renderAction = action => (
      <Menu.Item
         key={action.text}
         disabled={action.disabled}
         onClick={e => this.handleActionClick(action, e)}
         mix={{ block: b(`menu-item${action.mix ? ` ${action.mix}` : ''}`) }}
      >
         {action.text}
      </Menu.Item>
   );

   renderActions = actions => {
      const actionsElements = [];
      actions.forEach(group => {
         if (group.items) {
            actionsElements.push(
               <Menu.Group title={group.title} key={group.title || group.items[0].text}>
                  {group.items.map(action => this.renderAction(action))}
               </Menu.Group>,
            );
         } else {
            actionsElements.push(this.renderAction(group));
         }
      });
      return actionsElements;
   };

   render() {
      const { visible, anchor, onOutsideClick, actions } = this.props;

      return (
         <Popup
            theme={'normal'}
            visible={visible}
            anchor={anchor}
            directions={['bottom-right']}
            onOutsideClick={onOutsideClick}
            autoclosable
            hasTail
         >
            <Menu theme={'normal'} size={'s'} mix={{ block: b('menu') }}>
               {this.renderActions(actions)}
            </Menu>
         </Popup>
      );
   }
}

ActionPopup.propTypes = {
   actions: PropTypes.arrayOf(
      PropTypes.shape({
         id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
         title: PropTypes.string,
         text: PropTypes.string,
         disabled: PropTypes.bool,
         items: PropTypes.arrayOf(
            PropTypes.shape({
               id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
               text: PropTypes.string.isRequired,
               disabled: PropTypes.bool,
               mix: PropTypes.string,
            }),
         ),
      }),
   ).isRequired,
   visible: PropTypes.bool,
   // eslint-disable-next-line react/forbid-prop-types
   anchor: PropTypes.object.isRequired,
   onActionClick: PropTypes.func.isRequired,
   onOutsideClick: PropTypes.func.isRequired,
};

ActionPopup.defaultProps = {
   visible: false,
};
