import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import { Chevron } from '../icons';

import './ArrowToggle.scss';

const b = block('arrow-toggle');

export default function ArrowToggle({ width, height, direction, className }) {
   return (
      <span style={{ width, height }} className={b({ direction }, className)}>
         <Chevron width={width} height={height} />
      </span>
   );
}

ArrowToggle.propTypes = {
   width: PropTypes.number.isRequired,
   height: PropTypes.number.isRequired,
   direction: PropTypes.oneOf(['top', 'left', 'bottom', 'right']),
   className: PropTypes.string,
};

ArrowToggle.defaultProps = {
   direction: 'bottom',
   className: '',
};
