import block from 'bem-cn-lite';
import React, { PureComponent } from 'react';
import { SuggestSelect, SuggestLayer } from '@yandex-infracloud-ui/libs';
import BalancersFormSection from '../BalancersFormSection/BalancersFormSection';

import './BalancersFormABCService.scss';

const b = block('abc-service');

export default class BalancersFormABCService extends PureComponent {
   state = {
      selectedABCService: this.props.abcServiceId,
      alertRecipientGroupId: undefined,
      isAbcValid: true,
      isAlertValid: true,
   };

   onABCSelect(e, data) {
      const newAbcServiceId = data ? data.id : undefined;
      this.setState({ selectedABCService: newAbcServiceId });
   }

   onRecipientsSelect(e, data) {
      if (data) {
         const groupId = parseInt(data.id, 10);

         if (!Number.isNaN(groupId)) {
            this.setState({ alertRecipientGroupId: groupId });
         }
      } else {
         this.setState({ alertRecipientGroupId: undefined });
      }
   }

   serialize() {
      const { selectedABCService, alertRecipientGroupId } = this.state;

      return { abcServiceId: selectedABCService, alertRecipientGroupId };
   }

   validate() {
      const { selectedABCService, alertRecipientGroupId } = this.state;
      const isAbcValid = selectedABCService !== undefined;
      const isAlertValid = alertRecipientGroupId !== undefined;

      this.setState({ isAbcValid, isAlertValid });

      return isAbcValid && isAlertValid;
   }

   render() {
      const { isAbcValid, selectedABCService, isAlertValid } = this.state;
      return (
         <BalancersFormSection title={'ABC Service'} className={b()}>
            <p>
               ABC service will be used as a quota account. Also its members will become the owners of the balancers and
               will receive related notifications — from monitoring, from related Startrek issues and so on.
            </p>
            <div className={b('row')}>
               <div className={b('title')}>ABC Service id</div>
               <div className={b('suggest')}>
                  <SuggestSelect
                     entityId={selectedABCService}
                     layer={SuggestLayer.Services}
                     onSelect={this.onABCSelect.bind(this)}
                     resolveItemOnInit={true}
                     clearOnSelect={false}
                  />
               </div>
               {!isAbcValid && <div className={b('error')}>ABC Service is required</div>}
            </div>
            <div className={b('row')}>
               <div className={b('title')}>Alert recipients</div>
               <div className={b('suggest')}>
                  <SuggestSelect
                     layer={SuggestLayer.Groups}
                     onSelect={this.onRecipientsSelect.bind(this)}
                     resolveItemOnInit={true}
                     clearOnSelect={false}
                  />
               </div>
               {!isAlertValid && <div className={b('error')}>Alert recipients are required</div>}
            </div>
         </BalancersFormSection>
      );
   }
}
