import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import Select from '../Select/Select';
import TextInput from '../TextInput/TextInput';

import './BalancersFormEndpointSet.scss';

const b = block('endpoint-set');

const BalancersFormEndpointSet = ({
   cluster,
   clusters,
   name,
   isValid,
   onClusterChange,
   onEndpointSetNameChange,
   onEndpointSetRemove,
   isTitleVisible = true,
}) => {
   const items = clusters.map(x => {
      if (typeof x === 'string') {
         return { key: `endpointSetCluster-${x}`, val: x, text: x.toUpperCase() };
      }

      return { key: `endpointSetCluster-${x.value}`, val: x.value, text: x.title };
   });

   return (
      <div className={b({ invalid: !isValid, 'title-hidden': !isTitleVisible })}>
         <div className={b('cluster-container')}>
            {isTitleVisible && <div className={b('title')}>Cluster</div>}
            <Select items={items} val={cluster} width={'max'} onChange={onClusterChange} />
         </div>
         <div className={b('endpoint-set-container')}>
            {isTitleVisible && <div className={b('title')}>Endpoint set</div>}
            <TextInput
               placeholder={'Enter endpoint set'}
               cls={b('endpoint-set-control')}
               text={name}
               onChange={onEndpointSetNameChange}
            />
            {!isValid && <div className={b('error')}>String does not match pattern: ^[A-Za-z0-9-_.]+$</div>}
         </div>

         <i
            className={`far fa-times ${b('remove')}`}
            onClick={onEndpointSetRemove}
            role={'button'}
            aria-label={'Remove'}
            tabIndex={0}
         />
      </div>
   );
};

BalancersFormEndpointSet.propTypes = {
   cluster: PropTypes.string.isRequired,
   // eslint-disable-next-line react/forbid-prop-types
   clusters: PropTypes.array.isRequired,
   name: PropTypes.string.isRequired,
   isValid: PropTypes.bool.isRequired,
   isTitleVisible: PropTypes.bool.isRequired,
   onClusterChange: PropTypes.func.isRequired,
   onEndpointSetNameChange: PropTypes.func.isRequired,
   onEndpointSetRemove: PropTypes.func.isRequired,
};

export default BalancersFormEndpointSet;
