import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './BalancersFormSection.scss';

const b = block('section');

const Section = ({ title, children, className = '' }) => (
   <div className={`${b()} ${className}`}>
      {title && <h1 className={b('title')}>{title}</h1>}
      <div className={b('content')}>{children}</div>
   </div>
);

Section.propTypes = {
   title: PropTypes.string,
   children: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.node), PropTypes.node]),
   className: PropTypes.string,
};

export default Section;
