import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { Link } from 'react-router-dom';

import { urlBuilder } from '../../../models';

import classes from './Breadcrumbs.module.css';

export interface BreadcrumbLink {
   name: string;
   url?: string;
}

const defaultLinks: BreadcrumbLink[] = [{ name: 'All', url: urlBuilder.home() }];

interface Props {
   className?: string;
   links: (BreadcrumbLink | undefined)[];
}

export const Breadcrumbs: React.FC<Props> = ({ links = defaultLinks, className }) => (
   <div className={className} data-test={'breadcrumbs'}>
      {(links.filter(Boolean) as BreadcrumbLink[]).map((link, i, items) => {
         const linkClassName = classNames(classes.link, {
            [classes.last]: i === items.length - 1,
         });

         return (
            <React.Fragment key={`breadcrumbs-${link.url}-${link.name}`}>
               {link.url ? (
                  <Link to={link.url} className={linkClassName}>
                     {link.name}
                  </Link>
               ) : (
                  <span className={linkClassName}>{link.name}</span>
               )}

               {i < items.length - 1 ? <span className={classes.slash}>/</span> : null}
            </React.Fragment>
         );
      })}
   </div>
);
