import { Button } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './Button.scss';

export default function ButtonComponent(props) {
   const { text, children } = props;

   return (
      <Button theme={'normal'} size={'s'} {...props} text={text ?? ''}>
         {children || null}
      </Button>
   );
}

ButtonComponent.propTypes = {
   children: PropTypes.node,
   text: PropTypes.string,
};
