import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './Card.scss';

const b = block('card');

export default function Card(props) {
   const { children, active, className } = props;

   return (
      // eslint-disable-next-line react/jsx-props-no-spreading
      <div {...props} className={b({ active }, className)}>
         {children}
      </div>
   );
}

Card.propTypes = {
   active: PropTypes.bool,
   className: PropTypes.string,
   children: PropTypes.node.isRequired,
};
