import { CheckBox } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

export default function CheckBoxComponent(props) {
   const { readonly, checked, children, text } = props;

   return (
      <>
         <CheckBox
            theme={'normal'}
            view={'default'}
            tone={'default'}
            size={'s'}
            {...props}
            {...(readonly
               ? {
                    disabled: true,
                 }
               : {})}
            checked={checked}
            text={text || ''}
         >
            {children || null}
         </CheckBox>
      </>
   );
}

CheckBoxComponent.propTypes = {
   readonly: PropTypes.bool,
   checked: PropTypes.bool,
   children: PropTypes.node,
   text: PropTypes.string,
};
