import { classNames } from '@yandex-infracloud-ui/libs';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';

import TextInput from '../TextInput/TextInput';

import './ColoredInput.scss';

const b = block('colored-input');

export default class ColoredInput extends Component {
   static propTypes = {
      text: PropTypes.string,
      rules: PropTypes.objectOf(PropTypes.array),
      className: PropTypes.string,
   };

   renderColoredText() {
      const { text, rules } = this.props;
      const regexRules = Object.keys(rules).reduce((s, e) => ({ ...s, [e]: rules[e][0] }), {});
      const parsedText = parse(text || '', regexRules);

      return parsedText.map(({ type, text: t }, i) => (
         <span key={t} className={type ? rules[type][1] : ''}>
            {t}
         </span>
      ));
   }

   render() {
      return (
         <div className={classNames(b(), this.props.className)}>
            <TextInput {...this.props} />
            <div className={b('color-container')}>
               <span className={b('color-text')}>{this.renderColoredText()}</span>
            </div>
         </div>
      );
   }
}

/**
 * @param {string} text
 * @param {Object<string, RegExp>} rules
 * @returns {({text: string, type: (string|boolean)})[]}
 */
function parse(text, rules) {
   let currentTexts = [text];
   for (const type of Object.keys(rules)) {
      const regex = rules[type];
      for (let j = 0; j < currentTexts.length; j += 1) {
         const textPart = currentTexts[j];
         if (typeof textPart !== 'string') {
            // eslint-disable-next-line no-continue
            continue;
         }
         const globalRegex = new RegExp(regex.source, [...new Set([...regex.flags.split(''), 'g'])].join(''));
         const data = textPart.match(globalRegex);
         if (data) {
            const texts = textPart.split(regex);
            const list = [];
            for (let i = 0; i < texts.length; i += 1) {
               const textItem = texts[i];
               if (textItem) {
                  list.push(textItem);
               }
               if (i !== texts.length - 1) {
                  list.push({ type, text: data[i] });
               }
            }
            currentTexts[j] = list;
         }
      }

      const newTexts = [];
      for (const item of currentTexts) {
         newTexts.push(...(Array.isArray(item) ? item : [item]));
      }

      currentTexts = newTexts;
   }

   const result = [];
   for (const item of currentTexts) {
      result.push(typeof item === 'string' ? { type: false, text: item } : item);
   }

   return result;
}
