import { Meta } from '@storybook/react';
import React, { useState } from 'react';
import { DevJson } from '../../../components/lib';
import ColoredInput from './ColoredInput';

export const Regular = () => {
   const [value, setValue] = useState('');

   return (
      <>
         <ColoredInput
            text={value}
            rules={{
               object: [/^[a-zA-Z0-9-_]+/, 'highlight-object'],
               tag: [/#[\w-]+\b/i, 'tag'],
            }}
            onChange={setValue}
         />

         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export default {
   title: 'old-code/components/ColoredInput',
} as Meta;
