import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';

import Button from '../Button/Button';

import './ContainerError.scss';

const b = block('container-error');

export default class ContainerError extends Component {
   static propTypes = {
      title: PropTypes.string.isRequired,
      description: PropTypes.string,
      actionText: PropTypes.string,
      actionCallback: PropTypes.func,
   };

   static defaultProps = {
      actionText: 'Try again',
   };

   render() {
      const { title, description, actionText, actionCallback } = this.props;

      return (
         <div className={b()}>
            <div className={b('title')}>{title}</div>
            {description && <div className={b('description')}>{description}</div>}
            {actionText && (
               <div className={b('action')}>
                  <Button size={'m'} onClick={actionCallback}>
                     {actionText}
                  </Button>
               </div>
            )}
         </div>
      );
   }
}
