import { Loader } from '@yandex-cloud/uikit';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';

import './ContainerLoader.scss';

const b = block('container-loader');

export default class ContainerLoader extends Component {
   static propTypes = {
      text: PropTypes.string,
      delay: PropTypes.number,
      className: PropTypes.string,
   };

   static defaultProps = {
      text: 'Loading...',
      delay: 250,
   };

   state = {
      show: false,
   };

   componentDidMount() {
      this.showWithDelay();
   }

   componentWillUnmount() {
      this.clearTimer();
   }

   showWithDelay() {
      const { delay } = this.props;

      this.timer = setTimeout(() => {
         this.setState({ show: true });
      }, delay);
   }

   clearTimer() {
      clearTimeout(this.timer);
      this.timer = null;
   }

   render() {
      const { text, className } = this.props;
      const { show } = this.state;

      if (!show) {
         return null;
      }

      return (
         <div className={b(false, className)}>
            <div className={b('inner')}>
               <div className={b('icon')}>
                  <Loader size={'l'} />
               </div>
               <div className={b('text')}>{text}</div>
            </div>
         </div>
      );
   }
}
