import '@fortawesome/fontawesome-pro/css/fontawesome.min.css';
import '@fortawesome/fontawesome-pro/css/regular.min.css';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import { noop } from '../../../utils';

import './CopyToClipboard.scss';

const b = block('copy-to-clipboard');

export default class CopyToClipboard extends React.Component {
   static propTypes = {
      value: PropTypes.oneOfType([PropTypes.number, PropTypes.string, PropTypes.object]),
      icon: PropTypes.string,
   };

   state = {
      isCopied: false,
   };

   copyToClipboard = () => {
      this.valueRef.select();
      document.execCommand('copy');

      this.setState({
         isCopied: true,
      });

      setTimeout(() => {
         this.setState({
            isCopied: false,
         });
      }, 1000);
   };

   render() {
      const { value, icon } = this.props;
      const { isCopied } = this.state;

      return (
         <div className={b()}>
            <textarea
               className={b('value')}
               ref={element => {
                  this.valueRef = element;
               }}
               value={value}
               onChange={noop}
            />
            <i
               title={'Click to copy value'}
               onClick={this.copyToClipboard}
               role={'button'}
               aria-label={'Copy'}
               tabIndex={0}
               className={`far fa-${icon || 'copy'} ${b('icon', { 'is-copied': isCopied })}`}
            />
            {isCopied && <div className={b('copied')}>Copied!</div>}
         </div>
      );
   }
}
