import { ClipboardButton } from '@yandex-cloud/uikit';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './DefinitionList.scss';

const propTypes = {
   items: PropTypes.arrayOf(
      PropTypes.shape({
         name: PropTypes.oneOfType([PropTypes.string, PropTypes.node]).isRequired,
         value: PropTypes.oneOfType([PropTypes.string, PropTypes.node]).isRequired,
         withCopy: PropTypes.bool,
         theme: PropTypes.oneOf(['success', 'info', 'error', 'mute']),
      }),
   ).isRequired,
   className: PropTypes.string,
};

const b = block('definition-list');

const renderClipboardButton = value => (
   <div className={b('clipboard-button')}>
      <ClipboardButton text={value} size={16} />
   </div>
);

export default function DefinitionList({ items, className }) {
   return (
      <dl className={b(null, className)}>
         {items.map(({ name, value, theme, withCopy, mix }, index) => (
            <div key={name} className={b('item', mix)}>
               <dt className={b('term')}>{name}</dt>
               <div className={b('dots')} />
               <dd className={b('definition', { theme, 'with-copy': withCopy })}>
                  {value}
                  {withCopy && renderClipboardButton(value)}
               </dd>
            </div>
         ))}
      </dl>
   );
}

DefinitionList.propTypes = propTypes;
