import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import './InfracloudIconButton.scss';

const b = block('infracloud-icon-button');

const InfracloudIconButton = props => {
   const { size, icon, onClick, className, title } = props;

   return (
      <button size={size} onClick={onClick} className={`${b({ size })} ${className}`} title={title} type={'button'}>
         <i className={`far ${icon} ${b('icon')}`} />
      </button>
   );
};

InfracloudIconButton.propTypes = {
   size: PropTypes.string,
   icon: PropTypes.string,
   onClick: PropTypes.func,
   className: PropTypes.string,
   title: PropTypes.string,
};

InfracloudIconButton.defaultProps = {
   size: 's',
};

export default InfracloudIconButton;
