import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import spacings from '../InfracloudSpacings/InfracloudSpacings';
import './InfracloudIconPlusText.scss';

const b = block('ifracloud-icon-plus-text');

const InfracloudIconPlusText = props => {
   const { icon, text, className } = props;

   return (
      <div className={`${b()} ${className}`}>
         <i className={`far ${icon} ${b('icon', null, spacings({ 'indent-r': '2xs' }))}`} />
         <span className={b('text')}>{text}</span>
      </div>
   );
};

InfracloudIconPlusText.propTypes = {
   icon: PropTypes.string,
   text: PropTypes.string,
   className: PropTypes.string,
};

export default InfracloudIconPlusText;
