import block from 'bem-cn-lite';
import { UserAccount } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import Link from '../../Link/Link';
import spacings from '../InfracloudSpacings/InfracloudSpacings';

import './InfracloudOwners.scss';

const b = block('infracloud-owners');

const InfracloudOwners = props => {
   const { abcService, owners, groups, ...restProps } = props;

   const ownerLinks = owners.map(owner => (
      <UserAccount
         key={owner}
         uid={owner}
         name={owner}
         avatarId={owner}
         hasAccentLetter={true}
         url={`https://staff.yandex-team.ru/${owner}`}
         avatarHost={'https://center.yandex-team.ru'}
         provider={'yandex-team'}
         pic={false}
         cls={b('owner-link')}
      />
   ));
   const groupItems = groups.map(group => (
      <span key={group} className={b('owner-grous')}>
         {group}
      </span>
   ));

   const items = ownerLinks.concat(groupItems);

   return (
      <div className={b()} {...restProps}>
         {abcService ? (
            <div className={b('row', null, spacings({ 'indent-b': 's' }))}>
               <div className={b('title')}>ABC-service</div>
               <div className={b('content', { 'abc': true })}>
                  <Link
                     url={`https://abc.yandex-team.ru/services/${abcService.id}`}
                     target={'_blank'}
                     rel={'noopener noreferrer'}
                  >
                     {abcService.title} <i className={`far fa-external-link-square-alt ${b('external-link')}`} />
                  </Link>
               </div>
            </div>
         ) : null}
         {items.length ? (
            <div className={b('row')}>
               <div className={b('title')}>Owner</div>
               <div className={b('content', { users: true })}>{items}</div>
            </div>
         ) : null}
      </div>
   );
};

InfracloudOwners.propTypes = {
   abcService: PropTypes.shape({
      id: PropTypes.number,
      title: PropTypes.string,
   }),
   owners: PropTypes.arrayOf(PropTypes.string),
   groups: PropTypes.arrayOf(PropTypes.string),
};

InfracloudOwners.defaultProps = {
   owners: [],
   groups: [],
};

export default InfracloudOwners;
