import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import Status from '../../Status/Status';
import spacings from '../InfracloudSpacings/InfracloudSpacings';
import './InfracloudStatusLights.scss';

const b = block('infracloud-status-lights');

const defaultText = {
   active: 'Active',
   progress: 'In progress',
   error: 'Invalid',
};

const InfracloudStatusLights = props => {
   const { error, progress, active, total, isAnimated, className } = props;

   const getPropertyViewData = propName => {
      const propValue = props[propName];
      if (typeof propValue === 'object') {
         return {
            count: propValue.count,
            text: propValue.text || defaultText[propName],
         };
      }

      return {
         count: propValue,
         text: defaultText[propName],
      };
   };

   const activeViewData = getPropertyViewData('active');
   const progressViewData = getPropertyViewData('progress');
   const errorViewData = getPropertyViewData('error');

   return (
      <div className={`${b()} ${className}`}>
         {total !== null && total !== undefined ? (
            <span className={b('total-container', null, spacings({ 'indent-r': 's' }))}>{total} Total</span>
         ) : null}
         {error !== null && error !== undefined ? (
            <Status
               isAnimated={isAnimated}
               state={'error'}
               className={b('status', null, spacings({ 'indent-l': 'xs' }))}
            >
               {errorViewData.count} {errorViewData.text}
            </Status>
         ) : null}
         {progress !== null && progress !== undefined && (
            <Status
               isAnimated={isAnimated}
               state={'progress'}
               className={b('status', null, spacings({ 'indent-l': 'xs' }))}
            >
               {progressViewData.count} {progressViewData.text}
            </Status>
         )}
         {active !== null && active !== undefined ? (
            <Status isAnimated={isAnimated} state={'ok'} className={b('status', null, spacings({ 'indent-l': 'xs' }))}>
               {activeViewData.count} {activeViewData.text}
            </Status>
         ) : null}
      </div>
   );
};

InfracloudStatusLights.propTypes = {
   active: PropTypes.oneOfType([
      PropTypes.number,
      PropTypes.shape({
         count: PropTypes.number,
         text: PropTypes.string,
      }),
   ]),
   progress: PropTypes.oneOfType([
      PropTypes.number,
      PropTypes.shape({
         count: PropTypes.number,
         text: PropTypes.string,
      }),
   ]),
   error: PropTypes.oneOfType([
      PropTypes.number,
      PropTypes.shape({
         count: PropTypes.number,
         text: PropTypes.string,
      }),
   ]),
   total: PropTypes.number,
   isAnimated: PropTypes.bool,
   className: PropTypes.string,
};

export default InfracloudStatusLights;
