import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import spacings from '../InfracloudSpacings/InfracloudSpacings';
import './InfracloudTable.scss';

const b = block('infracloud-table');

class InfracloudTable extends Component {
   renderHeaderItem = ({ title, key }) => {
      const { itemSpacing } = this.props;

      return (
         <th key={`header-item-${key}`} className={b('item', { header: true }, spacings({ ...itemSpacing }))}>
            {title}
         </th>
      );
   };

   getRowChunks = (singleRowItem, keySuffix = '') => {
      const { headerItems, idSelector, itemSpacing } = this.props;
      const rowKeyPath = typeof idSelector === 'string' ? singleRowItem[idSelector] : idSelector(singleRowItem);

      return headerItems.map(({ key }) => (
         <td
            key={`row-item-${key}-${rowKeyPath}-${keySuffix}`}
            className={b('item', { row: true }, spacings({ ...itemSpacing }))}
         >
            {singleRowItem[key]}
         </td>
      ));
   };

   renderRow = rowData => {
      const { idSelector } = this.props;

      if (Array.isArray(rowData)) {
         return rowData.map((nestedRowData, index) => {
            const itemChunks = this.getRowChunks(nestedRowData, index);
            const rowKeyPath = typeof idSelector === 'string' ? nestedRowData[idSelector] : idSelector(nestedRowData);

            /* eslint-disable react/no-array-index-key */
            return (
               <tr
                  key={`row-${rowKeyPath}-${index}`}
                  className={b('row', { 'no-border': index !== rowData.length - 1 })}
               >
                  {itemChunks}
               </tr>
            );
            /* eslint-enable react/no-array-index-key */
         });
      }

      const itemChunks = this.getRowChunks(rowData);
      const rowKeyPath = typeof idSelector === 'string' ? rowData[idSelector] : idSelector(rowData);

      return (
         <tr key={`row-${rowKeyPath}`} className={b('row')}>
            {itemChunks}
         </tr>
      );
   };

   render() {
      const { items, headerItems } = this.props;

      const headerContent = headerItems.map(this.renderHeaderItem);
      const tableContent = items.map(this.renderRow);

      return (
         <table className={b()}>
            <thead>
               <tr>{headerContent}</tr>
            </thead>
            <tbody>{tableContent}</tbody>
         </table>
      );
   }
}

InfracloudTable.propTypes = {
   items: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.object, PropTypes.arrayOf(PropTypes.object)])),
   headerItems: PropTypes.arrayOf(
      PropTypes.shape({
         title: PropTypes.string,
         key: PropTypes.string,
         isSortable: PropTypes.bool,
      }),
   ),
   idSelector: PropTypes.oneOfType([PropTypes.string, PropTypes.func]).isRequired,
   itemSpacing: PropTypes.object,
};

InfracloudTable.defaultProps = {
   items: [],
   headerItems: [],
};

export default InfracloudTable;
