import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import infraSpacings from '../InfracloudSpacings/InfracloudSpacings';

import './InfrauiContainer.scss';

const b = block('infraui-container');

class InfrauiContainer extends React.Component {
   constructor(props) {
      super(props);

      this.state = {
         isExpanded: props.isExpanded,
      };
   }

   componentDidUpdate(prevProps) {
      const { isExpanded } = this.props;
      const { isExpanded: prevExpanded } = prevProps;

      if (isExpanded !== prevExpanded) {
         this.setState({ isExpanded });
      }
   }

   onHeaderClick = () => {
      const { isInteractive } = this.props;
      const { isExpanded } = this.state;

      if (isInteractive) {
         this.setState({ isExpanded: !isExpanded });
      }
   };

   renderArrow() {
      const { isExpanded } = this.state;

      return (
         <div className={b('arrow-container', null, infraSpacings({ 'space-r': 's' }))}>
            <i className={`far fa-chevron-right ${b('arrow', { expanded: isExpanded })}`} />
         </div>
      );
   }

   render() {
      const {
         children,
         header,
         spacings,
         headerSpacings,
         contentSpacings,
         isInteractive,
         className,
         ...restProps
      } = this.props;
      const { isExpanded } = this.state;

      const headerElement = header ? (
         <div
            className={b('header', { expanded: isExpanded }, infraSpacings({ ...headerSpacings }))}
            onClick={this.onHeaderClick}
            data-test={'infracloud--container-header'}
            tabIndex={0}
            role={'button'}
            aria-label={'Header click'}
         >
            {isInteractive ? this.renderArrow() : null}
            {header}
         </div>
      ) : null;

      const contentElement =
         children && isExpanded ? (
            <div
               className={b('content', null, infraSpacings({ ...contentSpacings }))}
               data-test={'infracloud--container-content'}
            >
               {children}
            </div>
         ) : null;

      return (
         <div
            className={`${b({ interactive: isInteractive }, infraSpacings({ ...spacings }))} ${className}`}
            {...restProps}
         >
            {headerElement}
            {contentElement}
         </div>
      );
   }
}

InfrauiContainer.propTypes = {
   children: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.node), PropTypes.node]),
   header: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.node), PropTypes.node]),
   spacings: PropTypes.object,
   headerSpacings: PropTypes.object,
   contentSpacings: PropTypes.object,
   isInteractive: PropTypes.bool,
   isExpanded: PropTypes.bool,
   className: PropTypes.string,
};

InfrauiContainer.defaultProps = {
   spacings: {},
   headerSpacings: {},
   contentSpacings: {},
   isExpanded: true,
};

export default InfrauiContainer;
