import { Button } from '@yandex-cloud/uikit';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './Form.scss';
import { FormSection } from './FormSection';

const b = block('form');

export default class Form extends React.Component {
   static propTypes = {
      cancelText: PropTypes.string,
      children: PropTypes.node.isRequired,
      className: PropTypes.string,
      customButtons: PropTypes.bool,
      isSubmitting: PropTypes.bool,
      onCancelClick: PropTypes.func,
      onSubmit: PropTypes.func.isRequired,
      onSubmitClick: PropTypes.func,
      submitText: PropTypes.string.isRequired,
   };

   static defaultProps = {
      isSubmitting: false,
      onSubmitClick: () => {},
      cancelText: 'Cancel',
   };

   static Section = FormSection;

   render() {
      const {
         submitText,
         onSubmit,
         isSubmitting,
         children,
         className,
         onSubmitClick,
         cancelText,
         onCancelClick,
         dataTest,
         customButtons,
      } = this.props;
      return (
         <form className={b(false, className)} onSubmit={onSubmit} {...(dataTest ? { 'data-test': dataTest } : null)}>
            <div className={b('top')}>{children}</div>
            {!customButtons && (
               <div className={b('bottom')}>
                  <span data-test={`${dataTest}__button_submit`}>
                     <Button onClick={onSubmitClick} view={'action'} loading={isSubmitting}>
                        {submitText}
                     </Button>
                  </span>
                  {onCancelClick ? (
                     <span data-test={`${dataTest}__button_cancel`}>
                        <Button onClick={onCancelClick} view={'clear'} className={b('cancel-button')}>
                           {cancelText}
                        </Button>
                     </span>
                  ) : null}
               </div>
            )}
         </form>
      );
   }
}
