import { boolean, number } from '@storybook/addon-knobs';
import React from 'react';
import Button from '../Button/Button';
import CheckBox from '../CheckBox/CheckBox';
import RadioButton from '../RadioButton/RadioButton';
import Select from '../Select/Select';
import TextInput from '../TextInput/TextInput';

export const Regular = () => {
   const readonly = boolean('Readonly', false);
   const disabled = boolean('Disabled', false);
   const noValues = boolean('No values', false);
   const value = number('Value', 2, { range: true, min: 1, max: 3, step: 1 });

   return (
      <>
         <br />
         <TextInput readonly={readonly} disabled={disabled} text={noValues ? null : `TextInput value ${value}`} />
         <br />
         <br />
         <Select
            readonly={readonly}
            disabled={disabled}
            val={noValues ? null : `select-value-${value}`}
            items={
               noValues
                  ? null
                  : [
                       {
                          'key': 'select-value-1',
                          'val': 'select-value-1',
                          'text': 'Select value 1',
                       },
                       {
                          'key': 'select-value-2',
                          'val': 'select-value-2',
                          'text': 'Select value 2',
                       },
                       {
                          'key': 'select-value-3',
                          'val': 'select-value-3',
                          'text': 'Select value 3',
                       },
                    ]
            }
         />
         <br />
         <br />
         <RadioButton
            readonly={readonly}
            disabled={disabled}
            value={noValues ? null : `radio-button-value-${value}`}
            items={
               noValues
                  ? null
                  : [
                       {
                          'key': 'radio-button-value-1',
                          'value': 'radio-button-value-1',
                          'text': 'RadioButton value 1',
                       },
                       {
                          'key': 'radio-button-value-2',
                          'value': 'radio-button-value-2',
                          'text': 'RadioButton value 2',
                       },
                       {
                          'key': 'radio-button-value-3',
                          'value': 'radio-button-value-3',
                          'text': 'RadioButton value 3',
                       },
                    ]
            }
         />
         <br />
         <br />
         <CheckBox
            readonly={readonly}
            disabled={disabled}
            checked={noValues ? null : `check-box-value-${value}`}
            text={noValues ? null : `CheckBox value ${value}`}
         >
            {noValues ? null : `CheckBox children value ${value}`}
         </CheckBox>
         <br />
         <br />
         <Button disabled={disabled} text={noValues ? null : `Button text ${value} `}>
            {noValues ? null : `Children text  ${value}`}
         </Button>
      </>
   );
};

export default {
   title: 'components/Form',
};
