import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

const b = block('form');

export class FormSection extends React.Component {
   static propTypes = {
      title: PropTypes.string,
      children: PropTypes.node.isRequired,
   };

   render() {
      const { title, children } = this.props;

      return (
         <section className={b('section')}>
            {title ? <h2 className={b('section-title')}>{title}</h2> : null}
            <div className={b('section-content')}>{children}</div>
         </section>
      );
   }
}
