import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import { fieldMetaPropTypes } from 'redux-form';

import './FormField.scss';

const b = block('form-field');

/**
 * Обертка для отображения компонента компонента и сообщения об ошибке
 *
 * @export
 * @class FormField
 * @extends {React.Component}
 */
export default class FormField extends React.Component {
   static propTypes = {
      children: PropTypes.node.isRequired, // наш самописный компонент, который будет отображаться на форме
      meta: PropTypes.shape(fieldMetaPropTypes), // метаданные, которые будут прилетать из Field redux-form
      className: PropTypes.string,
      isAlwaysTouched: PropTypes.bool, // флаг, задающий, что компонент всегда в состоянии touched
   };

   /**
    * Возвращает состояние компонента: 'error', 'warning' или null для отсутствия сообщений
    *
    * @returns
    * @memberof FormField
    */
   getState() {
      const {
         meta: { touched, error, warning },
         isAlwaysTouched,
      } = this.props;

      if ((touched || isAlwaysTouched) && error) {
         return 'error';
      }

      if ((touched || isAlwaysTouched) && warning) {
         return 'warning';
      }

      return null;
   }

   renderContent() {
      const { children } = this.props;

      return (
         <div className={b('content')} data-test={'form-field-content'}>
            {children}
         </div>
      );
   }

   renderMessage() {
      const {
         meta: { touched, error, warning },
         isAlwaysTouched,
      } = this.props;
      const message = error || warning;

      if (!(touched || isAlwaysTouched) || !message) {
         return null;
      }

      return (
         <div className={b('message')} data-test={'form-field-message'}>
            {message}
         </div>
      );
   }

   render() {
      const { className } = this.props;
      const state = this.getState();

      return (
         <div className={b({ state }, className)} data-test={'form-field'}>
            {this.renderContent()}
            {this.renderMessage()}
         </div>
      );
   }
}
