import block from 'bem-cn-lite';

import { CheckBox } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';
import { fieldPropTypes } from 'redux-form';

import FormField from '../FormField/FormField';

const b = block('form-field-checkbox');

export default class FormFieldCheckbox extends React.Component {
   static propTypes = {
      text: PropTypes.string,
      dataTest: PropTypes.string,
      renderContent: PropTypes.func,
      disabled: PropTypes.bool,
      ...fieldPropTypes,
   };

   render() {
      const {
         input: { onChange, value },
         meta,
         text,
         renderContent,
         disabled,
         dataTest,
      } = this.props;

      return (
         <FormField meta={meta} className={b()}>
            <div {...(dataTest ? { 'data-test': dataTest } : null)}>
               <CheckBox
                  theme={'normal'}
                  size={'s'}
                  checked={value}
                  onChange={onChange}
                  disabled={disabled}
                  view={'default'}
                  tone={'default'}
               >
                  {text || renderContent()}
               </CheckBox>
            </div>
         </FormField>
      );
   }
}
