import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import { fieldPropTypes } from 'redux-form';
import FormField from '../FormField/FormField';

import Suggest from '../Suggest/Suggest';

const b = block('form-field-suggest');

export default class FormFieldSuggest extends React.Component {
   static propTypes = {
      default: PropTypes.bool,
      data: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.object])).isRequired,
      filter: PropTypes.bool,
      isCommaSeparated: PropTypes.bool,
      noCustomValue: PropTypes.bool,
      filterBy: PropTypes.string,
      filterValueBy: PropTypes.string,
      placeholder: PropTypes.string,
      dataTest: PropTypes.string,
      ...fieldPropTypes,
   };

   static defaultProps = {
      default: false,
      filter: true,
      isCommaSeparated: false,
      filterBy: 'title',
      filterValueBy: 'title',
      placeholder: '',
   };

   constructor(props) {
      super(props);
      this.state = {};
   }

   onChange(text) {
      const {
         input: { onChange },
      } = this.props;
      onChange(text);
   }

   renderItem = item => {
      const { filterBy, renderItem } = this.props;

      return renderItem ? renderItem(item, filterBy) : item[filterBy];
   };

   render() {
      const {
         meta,
         data,
         disabled,
         filter,
         isCommaSeparated,
         filterBy,
         filterValueBy,
         placeholder,
         input: { value },
         dataTest,
         noCustomValue,
      } = this.props;

      return (
         <FormField meta={meta} className={b()}>
            <div {...(dataTest ? { 'data-test': dataTest } : null)}>
               <Suggest
                  disabled={disabled}
                  data={data}
                  renderItem={this.renderItem}
                  filterBy={filterBy}
                  filterValueBy={filterValueBy}
                  onChange={this.onChange.bind(this)}
                  onItemClick={this.onChange.bind(this)}
                  onAction={this.onChange.bind(this)}
                  filter={filter}
                  isCommaSeparated={isCommaSeparated}
                  placeholder={placeholder}
                  value={value}
                  noCustomValue={noCustomValue ?? false}
               />
            </div>
         </FormField>
      );
   }
}
