import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';
import { fieldPropTypes } from 'redux-form';

import FormField from '../FormField/FormField';
import TextInput from '../TextInput/TextInput';

const b = block('form-field-text');

export default class FormFieldText extends React.Component {
   static propTypes = {
      type: PropTypes.oneOf(['text', 'password']),
      disabled: PropTypes.bool,
      autoComplete: PropTypes.bool,
      autoFocus: PropTypes.bool,
      hasClear: PropTypes.bool,
      placeholder: PropTypes.string,
      accept: PropTypes.func,
      onSelect: PropTypes.func,
      blockModifications: PropTypes.object,
      dataTest: PropTypes.string,
      ...fieldPropTypes,
   };

   static defaultProps = {
      type: 'text',
      disabled: false,
      autoComplete: false,
      autoFocus: false,
      hasClear: true,
      blockModifications: {},
   };

   handleChange = value => {
      const {
         format,
         accept,
         input: { onChange },
      } = this.props;

      if (value !== '' && accept && !accept(value)) {
         return;
      }

      if (format) {
         onChange(format(value));
      } else {
         onChange(value);
      }
   };

   render() {
      const {
         type,
         disabled,
         autoComplete,
         autoFocus,
         hasClear,
         placeholder,
         input: { name, value, onFocus, onBlur },
         meta,
         blockModifications,
         onSelect,
         dataTest,
      } = this.props;

      return (
         <FormField meta={meta} className={b(blockModifications)}>
            <div {...(dataTest ? { 'data-test': dataTest } : null)}>
               <TextInput
                  type={type}
                  disabled={disabled}
                  autocomplete={autoComplete}
                  autoFocus={autoFocus}
                  hasClear={hasClear}
                  placeholder={placeholder}
                  name={name}
                  text={value}
                  onChange={this.handleChange}
                  onFocus={onFocus}
                  onBlur={onBlur}
                  onSelect={onSelect}
                  onKeyDown={e => {
                     if (e.key === 'Enter') {
                        e.preventDefault();
                     }
                  }}
               />
            </div>
         </FormField>
      );
   }
}
