import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './FormLayout.scss';
import { FormLayoutRow } from './FormLayoutRow';

const b = block('form-layout');

export default class FormLayout extends React.Component {
   static propTypes = {
      children: PropTypes.node.isRequired,
      className: PropTypes.string,
   };

   static Row = FormLayoutRow;

   render() {
      const { children, className } = this.props;

      return <div className={b(false, className)}>{children}</div>;
   }
}
