import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import TooltipInfo from '../TooltipInfo/TooltipInfo';

const b = block('form-layout');

export class FormLayoutRow extends React.Component {
   static propTypes = {
      title: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
      children: PropTypes.node.isRequired,
      note: PropTypes.string,
      className: PropTypes.string,
   };

   static defaultProps = {
      className: '',
   };

   render() {
      const { title, children, note, className } = this.props;

      return (
         <div className={`${b('row')} ${className}`}>
            <div className={b('row-left')}>
               <div className={b('row-title')}>{title}</div>
               <div className={b('row-note')}>
                  {note && note.length > 0 ? (
                     <>
                        &nbsp;
                        <TooltipInfo note={note} />
                     </>
                  ) : null}
               </div>
            </div>
            <div className={b('row-right')}>{children}</div>
         </div>
      );
   }
}
