import { Link } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './Link.scss';

export default class LinkComponent extends React.Component {
   static propTypes = {
      children: PropTypes.node,
      url: PropTypes.string,
      target: PropTypes.string,
      rel: PropTypes.string,
   };

   render() {
      const { children } = this.props;

      return (
         <Link theme={'normal'} target={'_blank'} {...this.props}>
            {children}
         </Link>
      );
   }
}
