import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';

import './MarkedText.scss';

const b = block('marked-text');

export default class MarkedText extends Component {
   static propTypes = {
      text: PropTypes.string,
      searchString: PropTypes.string,
      type: PropTypes.string,
      className: PropTypes.string,
   };

   render() {
      const { text, searchString, type, className } = this.props;
      if (!searchString) {
         return text;
      }
      const i = text.indexOf(searchString);
      if (i === -1) {
         return text;
      }
      return (
         <>
            {text.slice(0, i)}
            <span className={b({ type }, className)}>{searchString}</span>
            {text.slice(i + searchString.length)}
         </>
      );
   }
}
