import block from 'bem-cn-lite';
import { uniq } from 'lodash';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import BalancersFormABCService from '../BalancersFormABCService/BalancersFormABCService';
import BalancersFormBalancerInstances from '../BalancersFormBalancerInstances/BalancersFormBalancerInstances';
import BalancersFormEndpointSets from '../BalancersFormEndpointSets/BalancersFormEndpointSets';
import BalancersFormFQDN from '../BalancersFormFQDN/BalancersFormFQDN';
import Button from '../Button/Button';

import './NewBalancerForm.scss';

const b = block('new-balancer-form');

export default class NewBalancerForm extends Component {
   static propTypes = {
      stageId: PropTypes.string,
      abcServiceId: PropTypes.string,
      onFormSubmit: PropTypes.string,
      isFormProcessing: PropTypes.bool,
      project: PropTypes.array,
      clusters: PropTypes.array,
   };

   refsObject = {
      fqdn: React.createRef(),
      balancerInstances: React.createRef(),
      endpointSets: React.createRef(),
      abc: React.createRef(),
   };

   createBalancer() {
      const {
         refsObject: { fqdn, balancerInstances, endpointSets, abc },
         props: { onFormSubmit },
      } = this;
      let isValid = true;
      const refs = [fqdn, balancerInstances, endpointSets, abc];

      refs.forEach(formBlock => {
         const isBlockValid = formBlock.current.validate();
         isValid = isValid && isBlockValid;
      });

      if (isValid) {
         const { abcServiceId, alertRecipientGroupId } = abc.current.serialize();
         const { login } = window.USER;
         const fqdnData = fqdn.current.serialize();
         const endpointSetsData = endpointSets.current.serialize();
         const balancerInstancesData = balancerInstances.current.serialize();

         onFormSubmit(login, abcServiceId, alertRecipientGroupId, fqdnData, endpointSetsData, balancerInstancesData);
      }
   }

   render() {
      const { isFormProcessing, project: [project] = [], abcServiceId, clusters } = this.props;
      const { fqdn, balancerInstances, endpointSets, abc } = this.refsObject;
      const stageClusters = [];
      const stageDeployUnits = [];

      if (project) {
         const {
            status = {
               deploy_units: {},
            },
         } = project;

         const deployUnits = Object.keys(status.deploy_units);

         deployUnits.forEach(unitName => {
            const unit = status.deploy_units[unitName];
            const replicaSet = unit.replica_set || unit.multi_cluster_replica_set;

            if (replicaSet && replicaSet.cluster_statuses) {
               const clusterStatuses = replicaSet.cluster_statuses;
               const clusterKeys = Object.keys(clusterStatuses);

               clusterKeys.forEach(cluster => {
                  const endpointSetIds = clusterStatuses[cluster].endpoint_set_ids ?? [
                     clusterStatuses[cluster].endpoint_set_id,
                  ];

                  stageClusters.push(cluster);

                  endpointSetIds.forEach(endpointSetId => {
                     stageDeployUnits.push({ id: endpointSetId, cluster });
                  });
               });
            }
         });
      }

      return (
         <div className={b()}>
            <div className={b('content')}>
               <BalancersFormFQDN ref={fqdn} />
               <BalancersFormBalancerInstances
                  ref={balancerInstances}
                  stageClusters={uniq(stageClusters)}
                  clusters={clusters}
               />
               <BalancersFormEndpointSets ref={endpointSets} stageDeployUnits={stageDeployUnits} clusters={clusters} />
               <BalancersFormABCService ref={abc} abcServiceId={abcServiceId} />
            </div>
            <div className={b('controls')}>
               <Button theme={'action'} onClick={this.createBalancer.bind(this)} progress={isFormProcessing}>
                  Launch L7 balancer
               </Button>
            </div>
         </div>
      );
   }
}
