import { faArrowCircleUp, faCheckCircle, faExclamationCircle, faInfoCircle } from '@fortawesome/free-solid-svg-icons';
import { faTimes } from '@fortawesome/pro-regular-svg-icons';

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { YtError } from '../../../components';

import withNotifications from '../hoc/withNotifications';
import './Notification.scss';

const b = block('simple-notification');

class Notification extends Component {
   static propTypes = {
      notifications: PropTypes.object.isRequired,
      uid: PropTypes.number.isRequired,
      level: PropTypes.string.isRequired,
      title: PropTypes.string.isRequired,
      message: PropTypes.oneOfType([
         PropTypes.string,
         PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.func])),
      ]),
      ytError: PropTypes.object,
      action: PropTypes.object,
      close: PropTypes.bool,
   };

   static defaultProps = {
      close: true,
   };

   close = () => {
      const { notifications, uid } = this.props;

      notifications.remove(uid);
   };

   renderIcon() {
      const { level } = this.props;

      switch (level) {
         case 'error':
            return (
               <div className={b('icon', { error: true })}>
                  <FontAwesomeIcon icon={faExclamationCircle} />
               </div>
            );
         case 'success':
            return (
               <div className={b('icon', { success: true })}>
                  <FontAwesomeIcon icon={faCheckCircle} />
               </div>
            );
         case 'info':
            return (
               <div className={b('icon', { info: true })}>
                  <FontAwesomeIcon icon={faInfoCircle} />
               </div>
            );
         case 'upload':
            return (
               <div className={b('icon', { upload: true })}>
                  <FontAwesomeIcon icon={faArrowCircleUp} />
               </div>
            );
         default:
            return null;
      }
   }

   renderMessageContent() {
      const { message } = this.props;

      if (typeof message === 'string') {
         return <p className={b('text')}>{message}</p>;
      }

      if (Array.isArray(message)) {
         return (
            <p className={b('text')}>
               {/* eslint-disable-next-line react/jsx-key */}
               {message.map(str => (
                  <div>{str}</div>
               ))}
            </p>
         );
      }

      return null;
   }

   render() {
      const { title, action, close, ytError } = this.props;

      return (
         <div className={b()}>
            {this.renderIcon()}
            {close && (
               <button type={'button'} className={b('close')} onClick={this.close}>
                  <FontAwesomeIcon icon={faTimes} />
               </button>
            )}
            <h4 className={b('title')}>{title}</h4>
            {this.renderMessageContent()}
            {ytError && <YtError error={ytError} />}
            {action && (
               <button type={'button'} className={b('action')} onClick={action.handler}>
                  {action.text}
               </button>
            )}
         </div>
      );
   }
}

export default withNotifications(Notification);
