import PropTypes from 'prop-types';
import React, { Component } from 'react';

import NotificationSystem from '../../lib/react-notification-system';
import withNotifications from '../hoc/withNotifications';
import Notification from '../Notification/Notification';

import './NotificationsContainer.scss';

class NotificationsContainer extends Component {
   static propTypes = {
      notifications: PropTypes.object.isRequired,
   };

   componentDidMount() {
      const { notifications } = this.props;

      notifications.start({
         add: this.addNotification,
         edit: this.editNotification,
         remove: this.removeNotification,
      });
   }

   componentWillUnmount() {
      const { notifications } = this.props;

      notifications.stop();
   }

   setRef = ref => {
      this.notificationSystem = ref;
   };

   addNotification = data => {
      const notification = this.createNotification(data);

      return this.notificationSystem.addNotification(notification);
   };

   editNotification = (uid, data) => {
      const notification = this.createNotification(data);

      return this.notificationSystem.editNotification(uid, notification);
   };

   removeNotification = uid => this.notificationSystem.removeNotification(uid);

   createNotification(data) {
      const { title, message, level, action, close, ytError, ...restConfig } = data;

      return {
         ...restConfig,
         // `react-notification-system` requires this, but we don't care about it due we render content by ourselves
         level: 'info',
         children: (
            <Notification
               uid={restConfig.uid}
               title={title}
               message={message}
               ytError={ytError}
               level={level}
               action={action}
               close={close}
            />
         ),
      };
   }

   render() {
      // eslint-disable-next-line react/style-prop-object
      return <NotificationSystem ref={this.setRef} style={false} />;
   }
}

export default withNotifications(NotificationsContainer);
