import { useTitle } from '@yandex-infracloud-ui/libs';
import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './PageWrapper.scss';

const b = block('page-wrapper');

/**
 * Старая обертка над страницей
 *
 * Изначально была чисто визуальной. Сейчас также занимается установкой window.title, если передан в props.title.
 */
function PageWrapper({ title, children }) {
   useTitle(title);

   return (
      <div className={b()}>
         <div className={b('content')}>{children}</div>
      </div>
   );
}

PageWrapper.propTypes = {
   children: PropTypes.node,
   title: PropTypes.string,
};

export default PageWrapper;
