import { RadioButton, Spin } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './RadioButton.scss';

export default class RadioButtonComponent extends React.Component {
   static propTypes = {
      readonly: PropTypes.bool,
      items: PropTypes.arrayOf(
         PropTypes.shape({
            key: PropTypes.string.isRequired,
            value: PropTypes.string.isRequired,
            text: PropTypes.string.isRequired,
            meta: PropTypes.string,
         }),
      ).isRequired,
   };

   render() {
      const { readonly, items } = this.props;

      if (!items || !items.length) {
         return null;
      }

      return (
         <>
            <RadioButton
               theme={'normal'}
               view={'default'}
               tone={'grey'}
               size={'s'}
               freeWidth={true}
               {...this.props}
               {...(readonly
                  ? {
                       disabled: true,
                    }
                  : {})}
            >
               {items.map(({ key, value, text, meta }) => (
                  <RadioButton.Radio
                     key={key || value}
                     value={value}
                     {...(readonly
                        ? {
                             disabled: true,
                          }
                        : {})}
                  >
                     {text}
                     {meta && (
                        <>
                           {meta !== 'undefined' ? (
                              <span className={'radio-button__radio-meta'}>{meta}</span>
                           ) : (
                              <span className={'radio-button__radio-meta-spinner'}>
                                 <Spin size={'xxs'} progress />
                              </span>
                           )}
                        </>
                     )}
                  </RadioButton.Radio>
               ))}
            </RadioButton>
         </>
      );
   }
}
