import { Select } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './Select.scss';

export default class SelectComponent extends React.Component {
   static propTypes = {
      readonly: PropTypes.bool,
      items: PropTypes.arrayOf(
         PropTypes.shape({
            key: PropTypes.string.isRequired,
            val: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
            text: PropTypes.string.isRequired,
         }),
      ).isRequired,
   };

   render() {
      const { readonly, items } = this.props;

      return (
         <>
            <Select
               // view="default"
               theme={'normal'}
               size={'s'}
               type={'radio'}
               {...this.props}
               {...(readonly
                  ? {
                       disabled: true,
                    }
                  : {})}
               // TODO: убрать везде readonly, заменить на disabled?
               // disabled={disabled || readonly || !(items && items.length)}
               popup={{
                  onClose: () => {},
               }}
               {...(items && items.length ? {} : { disabled: true })}
            >
               {items && items.length
                  ? items.map(({ key, val, text }) => (
                       <Select.Item key={key || val} val={val}>
                          {text}
                       </Select.Item>
                    ))
                  : null}
            </Select>
            {/*
                    items && items.length > 0 ? null : (
                        <Spin size="xxs" progress/>
                    )
                */}
         </>
      );
   }
}
