import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { Component } from 'react';

import { Collapse } from '../icons';
import Icon from '../icons/Icon/Icon';

import './SideBar.scss';

const b = block('sidebar');

export default class SideBar extends Component {
   static propTypes = {
      children: PropTypes.node.isRequired,
      collapse: PropTypes.func.isRequired,
      className: PropTypes.string,
   };

   state = {
      left: `${document.documentElement.clientWidth}px`,
      right: '-600px',
   };

   componentDidMount() {
      this.setState(() => {
         const defaultWidth = 800;
         return {
            left: `${((w, d) => (w > d ? w - d : 0))(
               // [<- w-d ->|<- d ->] or [<- <d ->]
               document.documentElement.clientWidth,
               defaultWidth,
            )}px`,
            right: 0,
         };
      });
   }

   componentWillUnmount() {}

   onCollapseClick() {
      const { collapse } = this.props;
      this.setState(
         () => ({
            left: `${document.documentElement.clientWidth}px`,
            right: '-600px',
         }),
         collapse,
      );
   }

   render() {
      const { children, className } = this.props;
      const { left, right } = this.state;

      return (
         <div className={b(null, className)} style={{ left, right }}>
            <div className={b('header')}>
               <div
                  className={b('collapse')}
                  onClick={this.onCollapseClick.bind(this)}
                  role={'button'}
                  aria-label={'Collapse'}
                  tabIndex={0}
               >
                  <div>
                     <Icon className={b('collapse-icon')}>
                        <Collapse width={16} height={16} fill={'currentColor'} />
                     </Icon>
                  </div>
                  <div className={b('collapse-title')}>
                     <span>Collapse sidebar</span>
                  </div>
               </div>
            </div>
            <div className={b('content')}>{children}</div>
         </div>
      );
   }
}
