import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import Link from '../Link/Link';

import './StaffLink.scss';

const b = block('staff-link');

export default function StaffLinkComponent({ user }) {
   return (
      <span className={b()}>
         <Link theme={'black'} target={'_blank'} url={`https://staff.yandex-team.ru/${user}`}>
            <span>{user[0]}</span>
            {user.slice(1)}
         </Link>
      </span>
   );
}

StaffLinkComponent.propTypes = {
   children: PropTypes.node,
   url: PropTypes.node,
   target: PropTypes.node,
};
