import block from 'bem-cn-lite';
import dateFormat from 'dateformat';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { withRouter } from 'react-router';
import { setToListOptions, TagList } from '../../../components/forms/inputs/TagList/TagList';

import { urlBuilder } from '../../../models';

import Card from '../Card/Card';
import MarkedText from '../MarkedText/MarkedText';
import RouteLink from '../RouteLink/RouteLink';
import StageStatusBadge from '../StageStatusBadge/StageStatusBadge';

import './StageCard.scss';

const b = block('stage-card');

class StageCard extends Component {
   static propTypes = {
      stage: PropTypes.object.isRequired,
      globalFilters: PropTypes.object,
      isMy: PropTypes.bool,
   };

   renderName() {
      const {
         stage,
         globalFilters: { stage: searchStage, my },
         isMy,
      } = this.props;
      return (
         <div className={b('header')}>
            <div className={b('stage-name')}>
               <h3>
                  <MarkedText text={stage.meta.id} searchString={searchStage || ''} type={'stage'} />
               </h3>
            </div>
            {isMy && <div className={b('my-label', { accent: my !== 'yes' })}>my</div>}
         </div>
      );
   }

   render() {
      const { stage } = this.props;
      if (!stage || !stage.meta || !stage.spec || !stage.spec[Symbol.for('timestamp')]) {
         return null;
      }
      const tags = stage?.labels?.tags ?? [];

      return (
         <div data-test={`stage--${stage.meta.id}`} className={b()}>
            <RouteLink
               key={stage.meta.uuid}
               to={urlBuilder.stage(stage.meta.id)}
               theme={'clear'}
               mix={{ block: b('link') }}
            >
               <Card>
                  {this.renderName()}
                  <StageStatusBadge stageId={stage.meta.id} />
                  <div>Updated on {dateFormat(new Date(stage.spec[Symbol.for('timestamp')]), 'mmm d yyyy, H:MM')}</div>
                  {tags.length > 0 && (
                     <TagList editable={false} items={setToListOptions(new Set(tags))} className={b('tags')} />
                  )}
               </Card>
            </RouteLink>
         </div>
      );
   }
}

export default withRouter(StageCard);
