import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React, { useMemo } from 'react';
import { useHistory } from 'react-router';

import { setToListOptions, TagList } from '../../../components/forms/inputs/TagList/TagList';

import { urlBuilder } from '../../../models';
import { handleStopPropagation } from '../../../utils';
import Card from '../Card/Card';
import MarkedText from '../MarkedText/MarkedText';
import RouteLink from '../RouteLink/RouteLink';
import StageStatusBadge from '../StageStatusBadge/StageStatusBadge';

import './StageRolesCard.scss';

const b = block('stage-roles-card');

const StageRolesCard = ({
   additional,
   boxTypes,
   currentStageId,
   filterBoxType,
   onRolesClick,
   rolesCount,
   searchStage,
   stage,
   stageId,
}) => {
   const history = useHistory();
   const stageLink = urlBuilder.stage(stageId);

   const tags = useMemo(() => stage?.labels?.tags ?? [], [stage?.labels?.tags]);

   return (
      <Card key={stageId} style={{ display: 'inline-block' }} className={b()} onClick={() => history.push(stageLink)}>
         <div className={b('header')}>
            <div className={b('title')}>
               <RouteLink to={stageLink} theme={'black'} onClick={handleStopPropagation}>
                  <MarkedText text={stageId} searchString={searchStage} type={'stage'} />
               </RouteLink>
            </div>
            {/* eslint-disable-next-line jsx-a11y/no-static-element-interactions */}
            <div
               className={b('roles-button')}
               onClick={e => {
                  e.stopPropagation();
                  onRolesClick();
               }}
            >
               <i className={`fa${stageId === currentStageId ? 's' : 'r'} fa-user-friends`} />
               &nbsp;Roles
            </div>
         </div>
         <div style={{ color: additional ? 'black' : 'gray' }}>
            {additional ? `+ ${rolesCount} additional roles` : 'no additional roles'}
         </div>
         <div>
            <StageStatusBadge stageId={stage.meta.id} />
         </div>
         <div className={b('box-types')}>
            {boxTypes.length > 0 &&
               boxTypes.map((type, i) => (
                  <span key={type}>
                     {type === filterBoxType ? <span style={{ textDecoration: 'underline' }}>{type}</span> : type}
                     {i < boxTypes.length - 1 && ', '}
                  </span>
               ))}
         </div>

         {tags.length > 0 && <TagList editable={false} items={setToListOptions(new Set(tags))} className={b('tags')} />}
      </Card>
   );
};

StageRolesCard.propTypes = {
   additional: PropTypes.bool,
   boxTypes: PropTypes.arrayOf(PropTypes.string),
   currentStageId: PropTypes.string,
   filterBoxType: PropTypes.string,
   onRolesClick: PropTypes.func,
   rolesCount: PropTypes.number,
   searchStage: PropTypes.string,
   stage: PropTypes.object,
   stageId: PropTypes.string.isRequired,
};

export default StageRolesCard;
