import React from 'react';

import { Popover } from '@yandex-cloud/uikit';

import { useStage } from '../../../redux';
import { Status, StatusType } from '../../../components/lib';
import { stageStatusesMap } from '../../../models/ui/stage/Stage/StageStatusConverter';

const StageStatusBadge: React.FC<{ stageId: string }> = ({ stageId }) => {
   const { stageStatusLabel, meta, stage } = useStage(stageId, false, true);

   if (!stage || !stageStatusLabel || meta.isProcessing) {
      return null;
   }

   const { state, text, additional } = stageStatusLabel;

   const status = (
      <Status type={StatusType.Secondary} state={stageStatusesMap[state]}>
         {text}
      </Status>
   );

   if (!additional) {
      return status;
   }

   return <Popover content={<>{additional}</>}>{status}</Popover>;
};

export default StageStatusBadge;
