import block from 'bem-cn-lite';
import PropTypes from 'prop-types';
import React from 'react';

import './Status.scss';

const b = block('status');

export default class Status extends React.Component {
   static propTypes = {
      type: PropTypes.oneOf(['primary', 'secondary']),
      state: PropTypes.oneOf(['ok', 'error', 'progress', 'inactive', 'planned', 'default', 'unknown']),
      sign: PropTypes.oneOfType([PropTypes.bool, PropTypes.node]),
      isAnimated: PropTypes.bool,
      className: PropTypes.string,
   };

   static defaultProps = {
      type: 'secondary',
      isAnimated: true,
   };

   renderPrimaryStatus() {
      const { state, children } = this.props;
      return <div className={b('primary', { state })}>{children}</div>;
   }

   renderSign() {
      const { state, sign } = this.props;
      return typeof sign === 'boolean'
         ? {
              'ok': 'v',
              'error': '!',
              'progress': '...',
              'inactive': 'x',
           }[state]
         : sign || '-';
   }

   renderSecondaryStatus() {
      const { state, children, sign, isAnimated } = this.props;
      const getCircle = () => <div className={b('circle', { state })} />;
      return (
         <div className={b('secondary')}>
            {/* eslint-disable-next-line no-nested-ternary */}
            {sign ? (
               <div className={b('sign')}>{this.renderSign()}</div>
            ) : state === 'progress' ? (
               <div className={b('circle-pulse-container')}>
                  {getCircle()}
                  <div className={b('circle-pulse', { animated: isAnimated })} />
               </div>
            ) : (
               getCircle()
            )}
            <div className={b('text', { state })}>{children || state}</div>
         </div>
      );
   }

   render() {
      const { type, state, className } = this.props;
      const primaryStatus = this.renderPrimaryStatus.bind(this);
      const secondaryStatus = this.renderSecondaryStatus.bind(this);
      const contentMap = {
         'primary': primaryStatus,
         'secondary': secondaryStatus,
      };
      const content = contentMap[type]();
      return (
         <div className={`${b()} ${className}`}>
            <div className={b('box', { type, state })}>{content}</div>
         </div>
      );
   }
}
