import block from 'bem-cn-lite';
import { TextInput } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';

import './TextInput.scss';

const b = block('text-input');

export default class TextInputComponent extends React.Component {
   static propTypes = {
      readonly: PropTypes.bool,
      text: PropTypes.string,
      placeholder: PropTypes.string,
   };

   render() {
      const { readonly, text, placeholder } = this.props;

      return (
         <div className={b()}>
            <TextInput
               theme={'normal'}
               view={'default'}
               tone={'default'}
               size={'s'}
               {...this.props}
               {...(readonly
                  ? {
                       disabled: true,
                    }
                  : {})}
               text={text || ''}
               placeholder={placeholder || ''}
            />
         </div>
      );
   }
}
